<?php
// app/Http/Controllers/DashboardController.php

namespace App\Http\Controllers;

use App\Models\Prediksi;
use App\Models\Laporan;
use App\Models\Tangki;
use App\Models\Notifikasi;
use App\Services\AIPredictionService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    protected $aiService;
    
    public function __construct(AIPredictionService $aiService)
    {
        $this->middleware('auth');
        $this->aiService = $aiService;
    }
    
    public function index()
    {
        $user = Auth::user();
        
        // Get latest predictions
        $prediksiQuery = Prediksi::with('desa', 'dusun')
            ->where('tanggal_prediksi', '>=', now()->format('Y-m-d'))
            ->orderBy('tanggal_prediksi', 'asc');
        
        if ($user->role === 'warga' && $user->desa_id) {
            $prediksiQuery->where('desa_id', $user->desa_id);
        }
        
        $prediksi = $prediksiQuery->take(7)->get();
        
        // Statistics
        $stats = [
            'total_desa_kritis' => Prediksi::where('tingkat_risiko', 'kritis')
                ->where('tanggal_prediksi', now()->format('Y-m-d'))
                ->distinct('desa_id')->count('desa_id'),
            'total_laporan' => Laporan::where('status', 'pending')->count(),
            'tangki_dijadwalkan' => Tangki::where('status', 'dijadwalkan')->count(),
            'notifikasi_unread' => Notifikasi::where('user_id', $user->id)
                ->where('is_read', false)->count(),
        ];
        
        // Notifikasi terbaru
        $notifikasi = Notifikasi::where('user_id', $user->id)
            ->orWhere('desa_id', $user->desa_id)
            ->orderBy('created_at', 'desc')
            ->take(5)
            ->get();
        
        return view('dashboard.index', compact('prediksi', 'stats', 'notifikasi'));
    }
}
